# Tested on Python 3.9

import time
import socket
import urllib3
from urllib3.exceptions import SSLError
from urllib3.util import ssl_

# hostname to query

hostname = "eu-irl-00001.s3.dualstack.eu-west-1.amazonaws.com"
#hostname = "res.cdn.office.net"
#hostname = "uk.ng.msg.teams.microsoft.com"
#hostname = "gspe79-ssl.ls.apple.com"

ip_address = socket.gethostbyname(hostname)

print(f"Resolved hostname {hostname} to {ip_address}. This will be used for all further requests to simulate an application internally caching the resolved IP address.")
print()

# Create a new SSL context with the correct SNI
ssl_context = ssl_.create_urllib3_context()
ssl_context.load_default_certs()

while True:
    # Resolve all IP addresses
    ip_addresses = set([info[4][0] for info in socket.getaddrinfo(hostname, None)])

    print(f"All currently resolved IP addresses for hostname {hostname}: {ip_addresses}")

    print(f"Sending request to originally resolved IP address: {ip_address}")
    print()

    # Create a connection pool
    http = urllib3.HTTPSConnectionPool(
        ip_address, 
        port=443, 
        ssl_context=ssl_context, 
        server_hostname=hostname,
        assert_hostname=hostname,
    )

    try:
        response = http.request('GET', '/', retries=False)

        print(f"HTTP response code: {response.status}")
        print("HTTP response headers:")
        for header, value in response.headers.items():
            print(f"{header}: {value}")
    except SSLError as e:
        print(f"An SSL error occurred: {e}")
    except Exception as e:
        print(f"An error occurred: {e}")

    time.sleep(25)

    print()
